package com.intershop.support.app_sf_mycoupon_rest.capi.resourceobject;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.intershop.component.rest.capi.resourceobject.AbstractResourceObject;
import com.intershop.support.component.mycoupon.capi.MyCouponBO;

import io.swagger.v3.oas.annotations.media.Schema;

@XmlRootElement(name = MyCouponRO.TYPENAME)
@JsonTypeName(value = MyCouponRO.TYPENAME)
/**
 * This is the resource object for my coupon code.
 */
public class MyCouponRO extends AbstractResourceObject
{
    public final static String TYPENAME = "MyCoupon";
    public final static String NAME = "MyCoupon";

    private String code;

    public MyCouponRO(MyCouponBO myCouponBO)
    {
        super(NAME);
        setCode(myCouponBO.getCode());
    }

    /**
     * @return the coupon code
     */
    @Schema(description = "The coupon code")
    public String getCode()
    {
        return code;
    }

    /**
     * @param code the coupon code to set
     */
    public void setCode(String code)
    {
        this.code = code;
    }

    @Override
    @Schema(description = "The type of the object", example = TYPENAME)
    public String getType()
    {
        return TYPENAME;
    }
}
